#ifndef WSRULERS_H
#define WSRULERS_H

/* Word Solution "Rulers" Add-On package v2.01.  Copyright 1993 by DataPak
   Software, Inc.
   
   You must include WSIntf.h before this header  			*/
   

#define leftVerb 	0		/* Left indent verb */
#define rightVerb 	1		/* Right indent verb */
#define indentVerb  2		/* First line indent verb */
#define lTabVerb 	3		/* Left tab verb */
#define cTabVerb 	4		/* Center tab verb */
#define rTabVerb   	5		/* Right tab verb */
#define dTabVerb   	6		/* Decimal tab verb */
#define ljVerb  	7		/* Left justify */
#define cjVerb  	8		/* Center justify */
#define rjVerb  	9		/* Right justify */
#define fjVerb  	10		/* Full justify verb */
#define ssVerb  	11		/* Single spacing verb */
#define dsVerb  	12		/* Double spacing verb */
#define tsVerb  	13		/* Triple spacing verb */
#define lnVerb		16		/* Global left indent */


/* Border patterns */
        
#define bBlack  	-1		/* Black pattern */
#define bGray  		-2		/* Gray */
#define bLtGray  	-3		/* Light gray */
#define bDkGray  	-4		/* Dark gray */
#define bShadow  	-5		/* Shadow */
/* Positive pattern index = resource ID of pattern */

/* Line spacing */

#define spDefault  	0		/* None */
#define spAdded  	1		/* Added */
#define spPref  	2		/* Prefered */
#define spReq  		3		/* Required */
#define spMult		4		/* multiple */

/* Paragraph page break bits */

#define brkBeforeBit 2		/* Break before current paragraph */
#define brkAfterBit  4		/* Break after current paragraph */
#define brkLinesBit  8		/* Keep lines on same page */
#define brkParBit  	 16		/* Keep with next paragraph */
#define brkColAfterBit 32	/* Break column after paragraph */

/* Ruler icon mask bits */

#define showSSBit		0x0001	/* Show single-spacing icon */
#define showDSBit		0x0002	/* Show double-spacing icon */
#define showTSBit		0x0004	/* Show triple-spacing icon */
#define showAllSpacing	0x0007	/* Show all spacing icons */
#define noJustBit		0x2000	/* Do not show justification icons */
#define noTabsBit		0x4000  /* Do not show tab icons */
#define draw2PortBit	0x8000	/* Draw ruler all the way to portRect.right */


/* Direction settings (WordScript version */
#define sys_direction   0		/* Use System direction */
#define right_direction -1		/* Direction is right-to-left */
#define left_direction  1		/* Direction is left-to-right */


typedef struct {
		short	verb;			/* Tab type. Zero = no tab */
		short	pos;			/* Pixel position */
		short	leader;			/* Leader char */
} tabEntry, tabArray[1];
typedef tabArray *tabPtr, **tabHandle;

typedef struct {
	    short	onTop;			/* Top border enable */
		short	onLeft;			/* Left border enable */
		short	onBottom;		/* Bottom border enable */
		short	onRight;		/* Right border enable */
		Rect	spacing;		/* Pixel widths for borders */
		short	penPat;			/* pen pattern index for borders */
		Fixed	penSize;		/* Pen size for border (fractional) */
		short	strike;			/* Single, double, etc. */
} borderInfo;

typedef struct {
		long	rBegin;			/* Where it begins in text */
		short	left;			/* Left indent */
		short	right;			/* Right indent */
		short	indent;			/* 1st line indent */
		short	just;			/* Justification */
		tabEntry tabs[18];		/* Tabs stops*/
		borderInfo	border;		/* par border */
		short	flags;			/* Internal use attributes */
		Fixed	spacing;		/* Line spacing */
		short	spaceType;		/* Type of spacing */
		long	refCon;			/* For user */
} rulerRecord, *rulerPtr, **rulerHandle;

typedef struct {
		Fixed	rIncrement;		/* Pixels per increment */
		short	rNumIncs;		/* Number of increments per "inch" unit */
		short	rUnitNum;		/* Number symbol per unit */
		short	rHeight;		/* Height of ruler on screen */
		short	rBase1;			/* Height of first baseline */
		short	rBase2;			/* Height of second baseline */
		short	rZero;			/* What constitutes zeroth pixel */
		long	rFlags;			/* Special flags -- used internally */
		rulerRecord  rCurRuler;	/* Currently displaying ruler info */
} rulerInfo,*rulerInfoPtr,**rulerInfoHandle;

/* * Here is what baselines for ruler consist of: 

    ________________________________________________ > top of ruler
		|0.........|1.........|2..........|3
	________________________________________________ > rBase1 (from top)
	<ruler marks go here>
	________________________________________________ > rBase2 (from top)
	<general icons go here, e.g., tab selections >
	________________________________________________ > rHeight (from top)  */
	

/* EXTENDED WS */

typedef struct {
		WSRec	ws;				/* Main WS record */
		rulerHandle	rulers;		/* ruler array */
		WSHooksPtr	oldProcs;	/* Previous procs before patch */
		rulerInfoHandle defInfo; /* Ruler Info */
} WSRec2,*WSRec2Ptr,**WSHandle2;


#ifdef __cplusplus
extern	"C" {
#endif

/* THE FUNCTIONS */

pascal long WSRulerVersion (void);

pascal void WSInitRulers (short resID, rulerPtr defRuler);

pascal void WSSetNewRulerMask (short theMask);

pascal void WSRulerShutdown (void);

pascal void WSSetDefRuler (rulerRecord *defRuler);

pascal void WSGetDefRuler (rulerRecord *defRuler);

pascal void WSGetRulerInfo (WSHandle WS, rulerInfo *info);

pascal void WSSetRulerInfo (WSHandle WS, rulerInfo *info);

pascal void WSGetDefInfo (rulerInfo *info);

pascal void WSSetDefInfo (rulerInfo *info);

pascal long WSSetIndent (WSHandle WS, short verb, short indent);

pascal char WSGetIndent (WSHandle WS, short verb, short *indent);

pascal long WSNewTab (WSHandle WS, tabEntry *theTab);

pascal long WSChangeTab (WSHandle WS, short tabPos, tabEntry *theTab, tabEntry *mask);

pascal void WSGetTab (WSHandle WS, short tabPos, tabEntry *theTab, tabEntry *mask);

pascal short WSGetSelTab (WSHandle WS, tabEntry *theTab, tabEntry *mask);

pascal long WSSetJustify (WSHandle WS, short verb);

pascal char WSGetJustify (WSHandle WS, short *verb);

pascal long WSSetSpacing (WSHandle WS, Fixed spacing, short spType);

pascal char WSGetSpacing (WSHandle WS, Fixed *spacing, short *spType);

pascal long WSSetBorder (WSHandle WS, borderInfo *border, borderInfo *mask);

pascal void WSGetBorder (WSHandle WS, borderInfo *border, borderInfo *mask);

pascal void WSFillMask (borderInfo *theMask, short fillWord);

pascal long WSCopyPar (WSHandle WS, Point p);

pascal rulerHandle WSCopyRulers (WSHandle WS);

pascal long WSApplyRulers (WSHandle WS, rulerHandle rlr);

pascal rulerPtr WSFindRuler (WSHandle WS, long *Position, long *length);

pascal void WSPackRulers (WSHandle WS, Handle h);

pascal void WSUnpackRulers (WSHandle WS, Handle h);

pascal long WSSetRRefCon (WSHandle WS, long refCon);

pascal char WSGetRRefCon (WSHandle WS, long *refCon);

pascal long WSSetRulerRec (WSHandle WS, rulerRecord *rlr);

pascal void WSRulerBounds (WSHandle WS, short *left, short *right);

pascal void WSDrawRulerIcon (short verb, Point p, char disabled);
					
pascal void WSDrawRuler (WSHandle WS, char update);

pascal long WSFindRulerIcon (WSHandle WS, Point where);

pascal short WSTrackRuler (WSHandle WS, Point startPt, long what,
						short grid, ProcPtr idleProc);

pascal void WSDrawOneRuler (WSHandle WS, Rect *rulerRect, char update);

pascal long WSFindOneRulerIcon (WSHandle WS, Rect *rulerRect, Point p);

pascal short WSTrackOneRuler (WSHandle WS, Rect *rulerRect, Point startPt, long what,
						short grid, ProcPtr idleProc);

pascal long WSSetDirection (WSHandle WS, short direction);

pascal char WSGetDirection (WSHandle WS, short *direction);

pascal Handle WSPackHandle (WSHandle WS);

pascal WSHandle WSUnpackHandle (Handle h);


#ifdef __cplusplus
	}
#endif


#endif
